dofile(LockOn_Options.script_path.."Gunsight_K14/Indicator/K14_definitions.lua")

SymbologyBox_sizeX = 84
SymbologyBox_sizeY = 63

SymbologyBox = CreateElement "ceMeshPoly"
SymbologyBox.name = "SymbologyBox"
SymbologyBox.primitivetype = "triangles"

SymbologyBox.vertices	= { {-SymbologyBox_sizeX,-SymbologyBox_sizeY},
							{-SymbologyBox_sizeX,SymbologyBox_sizeY},
							{ SymbologyBox_sizeX,SymbologyBox_sizeY},
							 {SymbologyBox_sizeX,-SymbologyBox_sizeY}
							}

SymbologyBox.indices		 = default_box_indices
if K14_use_mirror_adjusting then
	SymbologyBox.init_pos		 = {0, 0,-0.03 / GetScale()}
else
	SymbologyBox.init_pos		 = {0.0, -3.0,  -45.0}
end
SymbologyBox.init_rot		 = {0, 0, -42.1}
SymbologyBox.material		 = "DBG_GREEN"
SymbologyBox.h_clip_relation = h_clip_relations.REWRITE_LEVEL
SymbologyBox.level			 = HUD_NOCLIP_LEVEL
SymbologyBox.isdraw			 = true
SymbologyBox.change_opacity	 = false
SymbologyBox.isvisible		 = false
Add(SymbologyBox)

total_field_of_view = CreateElement "ceMeshPoly"
total_field_of_view.name = "total_field_of_view"
total_field_of_view.primitivetype = "triangles"

num_points = 32
step = math.rad(360.0/num_points)

verts = {}
for i = 1, num_points do
	verts[i] = {TFOV * math.cos(i * step), TFOV * math.sin(i * step)}
end

total_field_of_view.vertices = verts

inds = {}
j = 0
for i = 0, 29 do
	j = j + 1
	inds[j] = 0
	j = j + 1
	inds[j] = i + 1
	j = j + 1
	inds[j] = i + 2
end

total_field_of_view.indices			= inds
total_field_of_view.init_pos		= {0,ZSL, 0}
total_field_of_view.material		= "DBG_RED"
total_field_of_view.h_clip_relation = h_clip_relations.INCREASE_IF_LEVEL
total_field_of_view.level			= HUD_DEFAULT_LEVEL - 1
total_field_of_view.isdraw			= true
total_field_of_view.change_opacity	= false
total_field_of_view.collimated 		= true
total_field_of_view.isvisible		= false
Add(total_field_of_view)


--Ln1 = addHWLine("Ln1", 250, 250, nil, {-150.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, nil, HUD_DEFAULT_LEVEL)
--Ln1.isdraw = true;

--[[ DrawRefLines = true

if DrawRefLines then
	ZSL_ref = addHWLine("ZeroLine", 40, 40, {}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, nil, nil)
	ZSL_ref.h_clip_relation = h_clip_relations.NULL;
	ZSL_ref.isdraw = true;

	ZSL_text = AddHUDTextElement_Pos_Val("ZSL_text", 
					{{"ZeroLine"}}, 
					{45, 0.0, 0.0}, 
					nil,
					HUD_DEFAULT_LEVEL,
					"LeftCenter",
					"ZSL")	
	ZSL_text.h_clip_relation = h_clip_relations.NULL

	GBL_ref = addHWLine("GunLine", 40, 40, {}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, nil, nil)
	GBL_ref.h_clip_relation = h_clip_relations.NULL;
	GBL_ref.isdraw = true;

	GBL_text = AddHUDTextElement_Pos_Val("GBL_text", 
					{},
					{45, 0.0, 0.0}, 
					nil,
					nil,--HUD_DEFAULT_LEVEL,
					"LeftCenter",
					"GBL")
	GBL_text.h_clip_relation = h_clip_relations.NULL
end ]]

--------------------------------------------------------------------------------

flag_draw_refgrid = false

-- reference grid
if flag_draw_refgrid then
	size = 1.0
	delta = 0.010
	sizeK = 200
	--[[for i = 1,17 do
	
	
		local elv = CreateElement "ceMeshPoly"
		elv.name       = "elv" .. string.format("%i", i)
		elv.primitivetype = "lines"
		elv.vertices   = {{-0.5 * sizeK, 0.0}, {0.5 * sizeK, 0.0}}
		elv.indices    = {0, 1}
		elv.init_pos   = {0.0, 0.0, 0}
		elv.material   = "INDICATION_COMMON_GREEN"
		elv.controllers = {{"dbg_linegrid", 0,  delta * (i-1)}}
		elv.collimated = true
		Add(elv)
		
		local elv2 = Copy(elv)
		elv2.controllers = {{"dbg_linegrid", 0,-delta * (i-1)}}
		Add(elv2)
	end
	for i = 1,17 do
	local elg = CreateElement "ceMeshPoly"
		elg.name       = "elg" .. string.format("%i", i)
		elg.primitivetype = "lines"
		elg.vertices   = {{0.0,-0.5 * sizeK}, {0.0,0.5 * sizeK}}
		elg.indices    = {0, 1}
		elg.init_pos   = {0.0, 0.0, 0}
		elg.material   = "INDICATION_COMMON_GREEN"	
		elg.controllers = {{"dbg_linegrid",delta * (i-1),0}}
		elg.collimated = true
		Add(elg)
		
		local elg2 = Copy(elg)
		elg2.controllers = {{"dbg_linegrid",-delta * (i-1),0}}
		Add(elg2)
	end]]
	local circle100 = CreateElement "ceMeshPoly"
		circle100.primitivetype = "triangles"
		set_circle(circle100,100,101)
		circle100.material   = "DBG_GREEN"
		circle100.collimated = true
		Add(circle100)
		
	--[[local circle90 = CreateElement "ceMeshPoly"
		circle90.primitivetype = "triangles"
		set_circle(circle90,109,110)
		circle90.material   = "DBG_RED"
		circle90.collimated = true
		Add(circle90)]]
		
	local circle625 = CreateElement "ceMeshPoly"
		circle625.primitivetype = "triangles"
		set_circle(circle625,6.25,7.25)
		circle625.material   = "DBG_GREEN"
		circle625.collimated = true
		Add(circle625)
		
		
	local circle0 = CreateElement "ceMeshPoly"
		circle0.primitivetype = "triangles"
		set_circle(circle0,40,41)
		circle0.material   = "DBG_GREEN"
		circle0.collimated = true
		Add(circle0)
end
